
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/
#include "qualifiedspectrum.h"

namespace pappso {
QualifiedSpectrum::QualifiedSpectrum()
{
}

QualifiedSpectrum::QualifiedSpectrum(const SpectrumId & spectrum_id)
    :_spectrum_id(spectrum_id)
{

    _original_spectrum_sp = nullptr;

}

QualifiedSpectrum::QualifiedSpectrum(const QualifiedSpectrum & other)
    :_spectrum_id(other._spectrum_id)
{

    _original_spectrum_sp = other._original_spectrum_sp;
    _precursor_charge=other._precursor_charge;
    _precursor_mz=other._precursor_mz;
    _precursor_intensity=other._precursor_intensity;
    _ms_level=other._ms_level;
    _rt_in_seconds=other._rt_in_seconds;
    _precursor_scan_num = other._precursor_scan_num;

}

QualifiedSpectrum::~QualifiedSpectrum()
{

}


const SpectrumId & QualifiedSpectrum::getSpectrumId() const {
    return _spectrum_id;
}
void QualifiedSpectrum::setSpectrumId(const SpectrumId & original_spectrum_id) {
    _spectrum_id = original_spectrum_id;
}

void QualifiedSpectrum::setOriginalSpectrumSp(SpectrumSp & original_spectrum_sp) {
    _original_spectrum_sp = original_spectrum_sp;
}
SpectrumSp QualifiedSpectrum::getOriginalSpectrumSp() const {
    return _original_spectrum_sp;
}
void QualifiedSpectrum::setPrecursorCharge(unsigned int precursor_charge) {
    _precursor_charge=precursor_charge;
}
unsigned int QualifiedSpectrum::getPrecursorCharge() const {
    return _precursor_charge;
}
void QualifiedSpectrum::setPrecursorMz(mz precursor_mz) {
    _precursor_mz=precursor_mz;
}
mz QualifiedSpectrum::getPrecursorMz() const {
    return _precursor_mz;
}
void QualifiedSpectrum::setMsLevel(unsigned int ms_level) {
    _ms_level=ms_level;
}
unsigned int QualifiedSpectrum::getMsLevel() const {
    return _ms_level;
}
void QualifiedSpectrum::setRtInSeconds(pappso_double rt_in_seconds) {
    _rt_in_seconds = rt_in_seconds;
}
pappso_double QualifiedSpectrum::getRtInSeconds() const {
    return _rt_in_seconds;
}
void QualifiedSpectrum::setPrecursorScanNum(unsigned long precursor_scan_num) {
    _precursor_scan_num = precursor_scan_num;
}
unsigned long QualifiedSpectrum::getPrecursorScanNum() const {
    return _precursor_scan_num;
}
    
    void QualifiedSpectrum::setPrecursorIntensity(pappso_double intensity) {
        _precursor_intensity = intensity;
    }
    pappso_double QualifiedSpectrum::getPrecursorIntensity() const  {
        return _precursor_intensity;
    }

}
