/**
 * \file pappsomspp/peptide/peptiderawfragmentmasses.h
 * \date 16/7/2016
 * \author Olivier Langella
 * \brief class dedicated to raw mass computations of peptide products (fragments)
 */

/*******************************************************************************
 * Copyright (c) 2016 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#ifndef PEPTIDERAWFRAGMENTMASSES_H
#define PEPTIDERAWFRAGMENTMASSES_H

#include "peptide.h"
#include "../spectrum/spectrum.h"
namespace pappso {


enum class RawFragmentationMode : std::int8_t {
    full=0, proline_effect=1
};


struct SimplePeakIonMatch {
    Peak peak;
    PeptideIon ion_type;
    unsigned int ion_size;
    unsigned int ion_charge;
    pappso::mz ion_mz;
};


class PeptideRawFragmentMasses
{
public:
    PeptideRawFragmentMasses(const Peptide & peptide, RawFragmentationMode mode);
    ~PeptideRawFragmentMasses();

    void pushBackIonMasses(std::vector<mz> & mass_list, PeptideIon ion_type) const;
    void pushBackIonMz(std::vector<mz> & mass_list, PeptideIon ion_type, unsigned int charge) const;

    void pushBackMatchSpectrum(std::vector<SimplePeakIonMatch> & peak_match_list, const Spectrum & spectrum, PrecisionP precision, PeptideIon ion_type, unsigned int charge) const;

private:
    /** \brief cumulative Nter masses (without internal Nter modification)
     * */
    std::vector<mz> _cumulative_nter_masses;

    /** \brief cumulative Cter masses (without internal Cter modification)
     * */
    std::vector<mz> _cumulative_cter_masses;

public:
    using ionDeltatMzMassMap = mz[20];

    static pappso_double getDeltaMass(PeptideIon ion_type);


private:
    static ionDeltatMzMassMap _ion_delta_mz;

};
}
#endif // PEPTIDERAWFRAGMENTMASSES_H
