
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#ifndef PEPTIDENATURALISOTOPEAVERAGE_H
#define PEPTIDENATURALISOTOPEAVERAGE_H


#include<vector>
#include"peptidenaturalisotope.h"

namespace pappso {

class PeptideNaturalIsotopeList;

class PeptideNaturalIsotopeAverage;

typedef std::shared_ptr<const PeptideNaturalIsotopeAverage> PeptideNaturalIsotopeAverageSp;

class PeptideNaturalIsotopeAverage
{
public:
    PeptideNaturalIsotopeAverage(const PeptideInterfaceSp & peptide, unsigned int askedIsotopeRank, unsigned int isotopeLevel, unsigned int charge, PrecisionP precision);
    PeptideNaturalIsotopeAverage(const PeptideNaturalIsotopeList & isotopeList, unsigned int askedIsotopeRank, unsigned int isotopeLevel, unsigned int charge, PrecisionP precision);
    
    PeptideNaturalIsotopeAverage(const PeptideNaturalIsotopeAverage& other);
    ~PeptideNaturalIsotopeAverage();

    PeptideNaturalIsotopeAverageSp makePeptideNaturalIsotopeAverageSp() const;
    mz getMz() const {
        return _averageMz;
    };
    pappso_double getIntensityRatio() const {
        return _abundanceRatio;
    };
    unsigned int getCharge() const {
        return _z;
    };
    unsigned int getIsotopeNumber() const {
        return _isotopeLevel;
    };
     unsigned int getIsotopeRank() const {
        return _isotopeRank;
    };
    const std::vector<PeptideNaturalIsotopeSp> & getComponents() const {
        return _peptide_natural_isotope_list;
    };
    const PeptideInterfaceSp & getPeptideInterfaceSp() const {
        return _peptideSp;
    };
    PrecisionP getPrecision() const {
        return _precision;
    };
    virtual bool matchPeak( mz peak_mz) const final {
       //qDebug() << "PeptideNaturalIsotopeAverage::matchPeak";
       //qDebug() << "PeptideNaturalIsotopeAverage::matchPeak precision " << _precision.getDelta(200);
        return (MassRange(getMz(),_precision).contains(peak_mz));
    }
    bool isEmpty() const {return (_peptide_natural_isotope_list.size()==0);};

private:
    const PeptideInterfaceSp _peptideSp;
    std::vector<PeptideNaturalIsotopeSp> _peptide_natural_isotope_list;

    mz _averageMz;
    pappso_double _abundanceRatio;
    unsigned int _isotopeLevel;
    unsigned int _isotopeRank=1;
    unsigned int _z;
    PrecisionP _precision = nullptr;
};
}
#endif // PEPTIDENATURALISOTOPEAVERAGE_H
