/**
 * \file pappsomspp/peptide/peptidenaturalisotope.h
 * \date 8/3/2015
 * \author Olivier Langella
 * \brief peptide natural isotope model
 */

/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/


#ifndef PEPTIDENATURALISOTOPE_H
#define PEPTIDENATURALISOTOPE_H

#include"peptide.h"
namespace pappso {


class PeptideNaturalIsotope;

typedef std::shared_ptr<const PeptideNaturalIsotope> PeptideNaturalIsotopeSp;

class PeptideNaturalIsotope:public PeptideInterface
{
public:
    PeptideNaturalIsotope(const PeptideInterfaceSp & peptide, const std::map<Isotope, int> & map_isotope);
    PeptideNaturalIsotope(const PeptideNaturalIsotope& other);
    ~PeptideNaturalIsotope();

    virtual unsigned int size() const override {
        return _peptide.get()->size();
    };
    virtual const QString getSequence() const override {
        return _peptide.get()->getSequence();
    };
    pappso_double getMass() const override;

    virtual int getNumberOfAtom(AtomIsotopeSurvey atom) const override;
    virtual int getNumberOfIsotope(Isotope isotope) const override;

    pappso_double getIntensityRatio(unsigned int charge) const;
    const std::map< Isotope, int > & getIsotopeMap() const ;

    virtual unsigned int getIsotopeNumber() const {
        //only count variable (natural) isotope
        return _map_isotope.at(Isotope::C13)+_map_isotope.at(Isotope::H2)+_map_isotope.at(Isotope::O17)+_map_isotope.at(Isotope::O18)*2+_map_isotope.at(Isotope::N15)+_map_isotope.at(Isotope::S33)+(_map_isotope.at(Isotope::S34)*2)+(_map_isotope.at(Isotope::S36)*4);
    };
private :
    const PeptideInterfaceSp _peptide;

    const std::map<Isotope, int> _map_isotope;
    pappso_double _ratio;
    pappso_double _mass;

};
}

#endif // PEPTIDENATURALISOTOPE_H
