/**
 * \file pappsomspp/peptide/peptidefragment.h
 * \date 10/3/2015
 * \author Olivier Langella
 * \brief peptide fragment model
 */

/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/


#ifndef PEPTIDEFRAGMENT_H
#define PEPTIDEFRAGMENT_H

#include "peptide.h"
#include "../pappsoexception.h"

namespace pappso {


class PeptideFragment;

typedef std::shared_ptr<const PeptideFragment> PeptideFragmentSp;

class PeptideFragment:public PeptideInterface
{
public:
    PeptideFragment(const PeptideSp & sp_peptide, PeptideDirection direction, unsigned int size);
    PeptideFragment(const PeptideFragment& other);
    PeptideFragment(PeptideFragment && toCopy); //move constructor
    ~PeptideFragment();

    virtual const PeptideSp & getPeptideSp() const {
        return _sp_peptide;
    };

    virtual unsigned int size() const override {
        return _size;
    };
    virtual const QString getSequence() const override;

    virtual pappso_double getMass() const override {
        return _mass;
    };
    static const QString getPeptideIonDirectionName(PeptideDirection direction);
    PeptideDirection getPeptideIonDirection() const {
        return _direction;
    };

    virtual int getNumberOfAtom(AtomIsotopeSurvey atom) const override;
    virtual int getNumberOfIsotope(Isotope isotope) const override;


private :
    const PeptideSp _sp_peptide;
    const PeptideDirection _direction;
    const unsigned int _size=0;
    // the aa modification to add on Nter or Cter aa (depending on peptide direction)
    AaModificationP _nter_cter_cleavage;

    pappso_double _mass = 0;
};
}

#endif // PEPTIDEFRAGMENT_H
