
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#include <QDir>
#include <QDebug>
#include "obopsimod.h"
#include "../pappsoexception.h"
#include <iostream>

inline void initMyResource() {
    Q_INIT_RESOURCE(libpappsomsppresources);
}


namespace pappso {


QRegExp   OboPsiModTerm::_first_parse("^([a-z,A-Z]+):\\s(.*)$");
QRegExp   OboPsiModTerm::_find_exact_psimod_label("^(.*)\\sEXACT\\sPSI-MOD-label\\s\\[\\]$");

//synonym: "Carbamidomethyl" RELATED PSI-MS-label []
QRegExp   OboPsiModTerm::_find_related_psims_label("^(.*)\\sRELATED\\sPSI-MS-label\\s\\[\\]$");

void OboPsiModTerm::parseLine(const QString & line) {
    //qDebug() << "OboPsiModTerm::parseLine begin " << line;
    //id: MOD:00007
    if (_first_parse.exactMatch(line)) {
        QStringList pline = _first_parse.capturedTexts();
        //qDebug() << "OboPsiModTerm::parseLine match " << pline[0] << pline[1];
        if (pline[1] == "id") {
            _accession = pline[2].trimmed();
            //qDebug() << "OboPsiModTerm::parseLine accession = " << _accession;
        } else if (pline[1] == "name") {
            _name = pline[2].trimmed();
            //qDebug() << "OboPsiModTerm::parseLine accession = " << _accession;
        } else if (pline[1] == "xref") {
            //xref: DiffMono: "1.007276"
            if (_first_parse.exactMatch(pline[2])) {
                QStringList psecond = _first_parse.capturedTexts();
                if (psecond[1] == "DiffMono") {
                    _diff_mono = psecond[2].replace("\"","").toDouble();
                    //qDebug() << "OboPsiModTerm::parseLine _diff_mono = " << _diff_mono;
                }
                else if (psecond[1] == "DiffFormula") {
                    _diff_formula = psecond[2].trimmed().replace("\"","");
                    //qDebug() << "OboPsiModTerm::parseLine _diff_formula = |" << _diff_formula<<"|";
                }
                else if (psecond[1] == "Origin") {
                    _origin = psecond[2].trimmed().replace("\"","").replace(",","");
                    //qDebug() << "OboPsiModTerm::parseLine _diff_formula = |" << _diff_formula<<"|";
                }
            }

        } else if (pline[1] == "synonym") {
            //synonym: "Se(S)Res" EXACT PSI-MOD-label []
            if (_find_exact_psimod_label.exactMatch(pline[2])) {
                _psi_mod_label = _find_exact_psimod_label.capturedTexts()[1].trimmed().replace("\"","");
                //qDebug() << "OboPsiModTerm::parseLine _psi_mod_label = |" << _psi_mod_label<<"|";
            } else if (_find_related_psims_label.exactMatch(pline[2])) {
                _psi_ms_label = _find_related_psims_label.capturedTexts()[1].trimmed().replace("\"","");
                //qDebug() << "OboPsiModTerm::parseLine _psi_mod_label = |" << _psi_mod_label<<"|";
            }
        }
    }

}
void OboPsiModTerm::clearTerm() {
    _accession="";
    _name="";
    _psi_mod_label="";
    _diff_formula="";
    _diff_mono=0;
    _origin="";
}

OboPsiMod::OboPsiMod(OboPsiModHandlerInterface & handler):_handler(handler)
{
    qDebug() << "OboPsiMod::OboPsiMod";
    initMyResource();
    parse();
}

OboPsiMod::~OboPsiMod()
{

}


void OboPsiMod::parse() {
// std::cout << "OboPsiMod::parse Begin parsing OBO file" << endl;
    qDebug() << "OboPsiMod::parse Begin parsing OBO file";
    QFile obofile(":/resources/PSI-MOD.obo");
    if (!obofile.exists()) {
      throw PappsoException(QObject::tr("PSI-MOD OBO resource file : %1 not found").arg(obofile.fileName()));
    }
    obofile.open(QIODevice::ReadOnly);
    QTextStream p_in(&obofile);

    //Search accession conta
    //QTextStream in(p_in);
    QString line = p_in.readLine();
    bool in_term = false;
    while (!p_in.atEnd()) {
        //qDebug() << "OboPsiMod::parse line "<< line;
        if (line.startsWith("[Term]")) {
            in_term = true;
            _term.clearTerm();
        } else if (line.isEmpty()) {
            if (in_term) {
                _handler.setOboPsiModTerm(_term);
                in_term = false;
            }
        } else {
            if (in_term) _term.parseLine(line);
            // _handler.setSequence(line);
        }
        line = p_in.readLine();
    }
    if (in_term) {
        _handler.setOboPsiModTerm(_term);
    }
    //p_in->close();

    obofile.close();
}

}
