
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#ifndef FILTEROBOPSIMODTERMDIFFMONO_H
#define FILTEROBOPSIMODTERMDIFFMONO_H

#include "obopsimod.h"
#include "../mass_range.h"

namespace pappso {
class FilterOboPsiModTermDiffMono: public OboPsiModHandlerInterface
{
public:
    FilterOboPsiModTermDiffMono(OboPsiModHandlerInterface & sink,const MassRange & mass_range);
    ~FilterOboPsiModTermDiffMono();

    void setOboPsiModTerm (const OboPsiModTerm & term) override;
private :
    const MassRange _mass_range;
    OboPsiModHandlerInterface & _sink;

};
}
#endif // FILTEROBOPSIMODTERMDIFFMONO_H
