/**
 * \file pappsomspp/msrun/private/pwizmsrunreader.h
 * \date 29/05/2018
 * \author Olivier Langella
 * \brief MSrun file reader base on proteowizard library
 */

/*******************************************************************************
* Copyright (c) 2018 Olivier Langella <Olivier.Langella@u-psud.fr>.
*
* This file is part of the PAPPSOms++ library.
*
*     PAPPSOms++ is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     PAPPSOms++ is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#ifndef PWIZMSRUNREADER_H
#define PWIZMSRUNREADER_H

#include "../msrunreaderfactory.h"
#include <pwiz/data/msdata/MSData.hpp>
#include <pwiz/data/msdata/MSDataFile.hpp>


namespace pappso {

class PwizMsRunReader: public MsRunReader
{
    friend MsRunReaderFactory;
public:
    virtual ~PwizMsRunReader();

    virtual SpectrumSp getSpectrumSp(unsigned int scan_num) override;
    virtual QualifiedSpectrum getQualifiedSpectrum(unsigned int scan_num) override;
    virtual void readSpectrumCollection(SpectrumCollectionHandlerInterface & handler) override;

    virtual unsigned long getSpectrumListSize() const override;

protected:
    PwizMsRunReader(const MsRunId & msrun_id);
    virtual void initialize() override;

    void getPwizMSDataFile();
    pappso::QualifiedSpectrum getQualifiedSpectrumFromPwizMSDataFile(unsigned int scan_num);
protected :
    pwiz::msdata::MSDataFile * _m_p_msdatafile = nullptr;
};

}
#endif // PWIZMSRUNREADER_H
