/**
 * \file pappsomspp/msrun/msrunreaderfactory.h
 * \date 29/05/2018
 * \author Olivier Langella
 * \brief factory to build MSrun reader
 */

/*******************************************************************************
* Copyright (c) 2018 Olivier Langella <Olivier.Langella@u-psud.fr>.
*
* This file is part of the PAPPSOms++ library.
*
*     PAPPSOms++ is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     PAPPSOms++ is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#ifndef MSRUNREADERFACTORY_H
#define MSRUNREADERFACTORY_H

#include "msrunreader.h"

namespace pappso {
    /** @brief factory to build different kinds of MSrun readers
     */
class MsRunReaderFactory
{
public:
    
    /** @brief singleton to get the only instance of the factory
     */
    static MsRunReaderFactory& getInstance();
    
        /** @brief build a MSrun reader that directly uses Proeowizard library
         * @param msrun_id the MsRun to read
     */
    MsRunReaderSp buildPwizMsRunReaderSp(const MsRunId & msrun_id) const;
    

private:

    MsRunReaderFactory();
    virtual ~MsRunReaderFactory();

private:
    static MsRunReaderFactory _m_instance;
};
}

#endif // MSRUNREADERFACTORY_H
