/**
 * \file pappsomspp/msrun/msrunreaderfactory.cpp
 * \date 29/05/2018
 * \author Olivier Langella
 * \brief factory to build MSrun reader
 */

/*******************************************************************************
* Copyright (c) 2018 Olivier Langella <Olivier.Langella@u-psud.fr>.
*
* This file is part of the PAPPSOms++ library.
*
*     PAPPSOms++ is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     PAPPSOms++ is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#include "msrunreaderfactory.h"
#include "private/pwizmsrunreader.h"

namespace pappso {


MsRunReaderFactory MsRunReaderFactory::_m_instance=MsRunReaderFactory();

MsRunReaderFactory& MsRunReaderFactory::getInstance()
{
    return _m_instance;
}


MsRunReaderFactory::MsRunReaderFactory() {
}
MsRunReaderFactory::~MsRunReaderFactory() {
}

MsRunReaderSp MsRunReaderFactory::buildPwizMsRunReaderSp(const MsRunId & msrun_id) const {
    std::shared_ptr<PwizMsRunReader> msrun_reader_sp = std::make_shared<PwizMsRunReader>(PwizMsRunReader(msrun_id));
    msrun_reader_sp.get()->initialize();
    return (msrun_reader_sp);
}

}
