/**
 * \file pappsomspp/msrun/msrunreader.cpp
 * \date 29/05/2018
 * \author Olivier Langella
 * \brief base interface to read MSrun files
 */

/*******************************************************************************
* Copyright (c) 2018 Olivier Langella <Olivier.Langella@u-psud.fr>.
*
* This file is part of the PAPPSOms++ library.
*
*     PAPPSOms++ is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     PAPPSOms++ is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#include "msrunreader.h"

namespace pappso {

bool MsRunSimpleStatistics::needPeakList () const {
    return false;
}
void MsRunSimpleStatistics::setQualifiedSpectrum (const QualifiedSpectrum & qspectrum) {
    unsigned int ms_level = qspectrum.getMsLevel();
    if (ms_level == 0) return;
    if (ms_level > _count_ms_level_spectrum.size()) {
        _count_ms_level_spectrum.resize(ms_level);
    }
    _count_ms_level_spectrum[ms_level-1]++;
}

unsigned long MsRunSimpleStatistics::getMsLevelCount(unsigned int ms_level) const {
    if (ms_level== 0) return 0;
    if (ms_level > _count_ms_level_spectrum.size()) return 0;
    return (_count_ms_level_spectrum[ms_level-1]);
}
 unsigned long MsRunSimpleStatistics::getTotalCount() const {
     unsigned long total = 0;
     for (unsigned long count : _count_ms_level_spectrum) {
         total += count;
     }
     return total;
 }

MsRunReader::MsRunReader(const MsRunId & msrun_id):_m_msrun_id(msrun_id) {
}

MsRunReader::MsRunReader(const MsRunReader & other):_m_msrun_id(other._m_msrun_id) {

}

MsRunReader::~MsRunReader() {
}
}
