
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/
#ifndef MSRUNID_H
#define MSRUNID_H

#include <QString>
#include "../types.h"

namespace pappso {

/** @brief MS run identity
 * MsRunid identifies an MS run with a unique ID (XmlId)
 * and contains eventually informations on its location (local disk path or URL)
 */
class MsRunId
{
public:


    MsRunId(const QString & location);
    MsRunId(const MsRunId& other);
    ~MsRunId();
    bool operator==(const MsRunId& other) const;
    MsRunId& operator=(const MsRunId& other);
    
    /** @brief set path to the MSrun data file
     */
    void setFilename(const QString filename);
    
    /** @brief set a sample name for this MS MsRunId
     */
    void setSampleName(const QString & name);
    
    /** @brief set an XML unique identifier for this MsRunId
     * @param xmlid this id must respect XML constraints (no space)
     */
    void setXmlId(const QString xmlid);
    
    const QString & getFilename() const;
    const QString & getSampleName() const;
    const QString & getXmlId() const;
    
    MzFormat getMzFormat() const;


private :
    QString _xml_id;
    QString _location;
    QString _name;
    MzFormat _mz_format=MzFormat::mzXML;

};
}

#endif // MSRUNID_H
