
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#include "msrunid.h"
#include <QFileInfo>

namespace pappso {


MsRunId::MsRunId(const QString & location) {
    _xml_id = location;
    _location = location;
    QFileInfo fileinfo(location);
    _name = fileinfo.baseName();
}

MsRunId::MsRunId(const MsRunId& other) {
    _xml_id = other._xml_id;
    _location = other._location;
    _name = other._name;
    _mz_format=other._mz_format;
}

MsRunId::~MsRunId() {
}


void MsRunId::setSampleName(const QString & name) {
    _name = name;
}
const QString & MsRunId::getSampleName() const {
    return _name;
}

void MsRunId::setFilename(const QString filename) {
    _location = filename;
    QFileInfo file_info(filename);
    QString extension = file_info.suffix();
    _mz_format = MzFormat::unknown;
    if (extension.toLower() == "mzxml") {
        _mz_format = MzFormat::mzXML;
    }
    else if (extension.toLower() == "mgf") {
        _mz_format = MzFormat::MGF;
    }
    else if (extension.toLower() == "mzml") {
        _mz_format = MzFormat::mzML;
    }
}
void MsRunId::setXmlId(const QString xmlid) {
    _xml_id = xmlid;
}
const QString & MsRunId::getXmlId() const {
    return _xml_id;
}
const QString & MsRunId::getFilename() const {
    return _location;
}

MzFormat MsRunId::getMzFormat() const {
    return _mz_format;
}

bool MsRunId::operator==(const MsRunId& other) const
{
    if (_xml_id == other._xml_id) return true;
    return false;

}
MsRunId& MsRunId::operator=(const MsRunId& other)
{
    _xml_id = other._xml_id;
    _location = other._location;
    _name = other._name;
    _mz_format=other._mz_format;
}
}
