
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#ifndef GRPPROTEIN_H
#define GRPPROTEIN_H

#include <memory>
#include <vector>
#include <QString>

#include "grppeptide.h"

namespace pappso {
class GrpProtein;
typedef std::shared_ptr<const GrpProtein> GrpProteinSpConst;
typedef std::shared_ptr<GrpProtein> GrpProteinSp;

class GrpProtein
{
    friend class GrpExperiment;
public:
    GrpProtein(const GrpProtein & other);
    ~GrpProtein();
    void push_back(GrpPeptide * p_grpPeptide);
    bool operator==(const GrpProtein& other) const;

    const QString & getAccession() const;
    const QString & getDescription() const;
    const QString getGroupingId() const;

    typedef std::vector<GrpPeptide *>::const_iterator const_iterator;
    const_iterator begin() const {
        return _grpPeptideList.begin();
    }
    const_iterator end() const {
        return _grpPeptideList.end();
    }
    void setRank(unsigned int i);
    void setGroupNumber(unsigned int i);
    void setSubGroupNumber(unsigned int i);
    unsigned int getGroupNumber() const ;
    unsigned int getSubGroupNumber() const ;
    unsigned int getRank() const ;
    unsigned int getCount() const;

protected:
    GrpProtein(const QString & accession, const QString & description);

    void countPlus();


    /** @brief ensure that each peptide in peptide list is unique and sorted by pointer adress
    */
    void strip();

private:
    unsigned int _group_number=0;
    unsigned int _subgroup_number=0;
    unsigned int _rank=0;
    unsigned int _count=0;

    const QString _accession;
    const QString _description;

    std::vector<GrpPeptide *> _grpPeptideList;
};
}
#endif // GRPPROTEIN_H
