
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#include "grpprotein.h"


#include "grpexperiment.h"
#include "grppeptide.h"
#include "../utils.h"

using namespace pappso;
GrpProtein::GrpProtein(const QString & accession, const QString & description):_accession(accession.simplified()), _description(description.simplified())
{

}


GrpProtein::GrpProtein(const GrpProtein & other):_accession(other._accession), _description(other._description), _grpPeptideList(other._grpPeptideList) {
}

GrpProtein::~GrpProtein()
{

}

unsigned int GrpProtein::getCount() const {
    return _count;
}
void GrpProtein::countPlus() {
    _count++;
}
void GrpProtein::setSubGroupNumber(unsigned int i) {
    _subgroup_number = i;
}

unsigned int GrpProtein::getGroupNumber() const {
    return _group_number;
}

unsigned int GrpProtein::getSubGroupNumber() const {
    return _subgroup_number;
}
unsigned int GrpProtein::getRank() const  {
    return _rank;
}
const QString GrpProtein::getGroupingId() const {
    if(_group_number==0) {
        return "";
    }
    return QString("%1.%2.%3").arg(Utils::getLexicalOrderedString(_group_number)).arg(Utils::getLexicalOrderedString(_subgroup_number)).arg(Utils::getLexicalOrderedString(_rank));
}
bool GrpProtein::operator==(const GrpProtein& other) const
{
    return (_accession == other._accession);
}


const QString & GrpProtein::getAccession() const {
    return _accession;
}
const QString & GrpProtein::getDescription() const {
    return _description;
}
void GrpProtein::push_back(GrpPeptide * p_grpPeptide) {
    // p_grpPeptide->push_back(this);
    _grpPeptideList.push_back(p_grpPeptide);
}

void GrpProtein::strip() {
    qDebug() << "GrpProtein::strip begin "<< this->_accession;
    //_grpPeptideList.sort();
    std::sort(_grpPeptideList.begin(), _grpPeptideList.end());
    //_grpPeptideList.unique();
    _grpPeptideList.erase(std::unique(_grpPeptideList.begin(), _grpPeptideList.end()), _grpPeptideList.end());
    qDebug() << "GrpProtein::strip end";

}

void GrpProtein::setRank(unsigned int i) {
    _rank = i;
}
void GrpProtein::setGroupNumber(unsigned int i) {
    _group_number = i;
}
