
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#include "grppeptide.h"
#include "../utils.h"

using namespace pappso;

GrpPeptide::GrpPeptide(QString sequence, pappso_double mass)
    :_sequence(sequence.replace("L","I")), _mass(mass)
{

}

GrpPeptide::~GrpPeptide()
{

}

bool GrpPeptide::operator<(const GrpPeptide& other) const {
    if (_sequence == other._sequence) {
          return (_mass < other._mass);
    }
    else {
        return (_sequence < other._sequence);
    }
}

void GrpPeptide::setRank(unsigned int i) {
    _rank = i;
}
void GrpPeptide::setGroupNumber(unsigned int i) {
    _group_number = i;
}

unsigned int GrpPeptide::getGroupNumber() const {
    return _group_number;
}
unsigned int GrpPeptide::getRank() const  {
    return _rank;
}
const QString & GrpPeptide::getSequence() const {
    return _sequence;
}
const QString GrpPeptide::getGroupingId() const {
    return QString("pep%1%2").arg(Utils::getLexicalOrderedString(_group_number)).arg(Utils::getLexicalOrderedString(_rank));
}
