/**
 * \file pappsomspp/amino_acid/aaBase.h
 * \date 7/3/2015
 * \author Olivier Langella
 * \brief private amino acid model
 */

/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/


#ifndef SRC_PAPPSOMSPP_AMINO_ACID_AABASE_H_
#define SRC_PAPPSOMSPP_AMINO_ACID_AABASE_H_

#include<map>

#include "../types.h"
#include "atomnumberinterface.h"

namespace pappso {

class aaBase : public AtomNumberInterface {
public:
    using AaMassMap = std::map<char, pappso_double>;
    using AaIntMap = std::map<char, unsigned int>;
public:
    virtual pappso_double getMass() const;
    virtual const char& getLetter() const {
        return _aa_letter;
    };
    
    virtual void replaceLeucineIsoleucine();

protected:
    aaBase(char aa_letter);
    aaBase(const aaBase & aabase);
    virtual ~aaBase();

    virtual int getNumberOfAtom(AtomIsotopeSurvey atom) const override;
    int getNumberOfIsotope(Isotope isotope) const override {
        return 0;
    };
    static pappso_double getAaMass(char aa_letter);
    char _aa_letter;

private:
    static AaMassMap _aa_mass_map;
    static AaIntMap _aa_number_of_carbon_map;
    static AaIntMap _aa_number_of_sulfur_map;
    static AaIntMap _aa_number_of_hydrogen_map;
    static AaIntMap _aa_number_of_nitrogen_map;
    static AaIntMap _aa_number_of_oxygen_map;


};

} /* namespace pappso */

#endif /* SRC_PAPPSOMSPP_AMINO_ACID_AABASE_H_ */
