# Copyright : Olivier Langella (CNRS)
# License : GPL-3.0+
# Authors : Olivier Langella

FIND_PATH( PAPPSOMSPP_INCLUDE_DIR pappsomspp/types.h
               PATHS /usr/local/include /usr/include
               PATH_SUFFIXES pappsomspp libpappsomspp ENV PATH)

FIND_LIBRARY(PAPPSOMSPP_QT4_LIBRARY NAMES pappsomspp-qt4)
IF (PAPPSOMSPP_INCLUDE_DIR AND PAPPSOMSPP_QT4_LIBRARY)
  MESSAGE(STATUS "XXXXXXXXXXXXX ${PAPPSOMSPP_QT4_LIBRARY} XXXXXXXXXXXXXXX")
  SET(PAPPSOMSPP_QT4_FOUND TRUE)
ENDIF (PAPPSOMSPP_INCLUDE_DIR AND PAPPSOMSPP_QT4_LIBRARY)

IF (PAPPSOMSPP_QT4_FOUND)
  # show which CppUnit was found only if not quiet
  IF (NOT PAPPSOMSPP_FIND_QUIETLY)
    MESSAGE(STATUS "Found PAPPSOMSPP_QT4_LIBRARY for Qt4: ${PAPPSOMSPP_QT4_LIBRARY}")
  ENDIF (NOT PAPPSOMSPP_FIND_QUIETLY)
ENDIF (PAPPSOMSPP_QT4_FOUND)


FIND_LIBRARY(PAPPSOMSPP_QT5_LIBRARY NAMES pappsomspp-qt5)
IF (PAPPSOMSPP_INCLUDE_DIR AND PAPPSOMSPP_QT5_LIBRARY)
  MESSAGE(STATUS "XXXXXXXXXXXXX ${PAPPSOMSPP_QT5_LIBRARY} XXXXXXXXXXXXXXX")
  SET(PAPPSOMSPP_QT5_FOUND TRUE)
ENDIF (PAPPSOMSPP_INCLUDE_DIR AND PAPPSOMSPP_QT5_LIBRARY)

IF (PAPPSOMSPP_QT5_FOUND)
  # show which CppUnit was found only if not quiet
  IF (NOT PAPPSOMSPP_FIND_QUIETLY)
    MESSAGE(STATUS "Found PAPPSOMSPP_QT5_LIBRARY for Qt5: ${PAPPSOMSPP_QT5_LIBRARY}")
  ENDIF (NOT PAPPSOMSPP_FIND_QUIETLY)
  

    FIND_LIBRARY(PAPPSOMSPP_WIDGET_QT5_LIBRARY NAMES pappsomspp-widget-qt5)
    IF (PAPPSOMSPP_INCLUDE_DIR AND PAPPSOMSPP_WIDGET_QT5_LIBRARY)
    MESSAGE(STATUS "XXXXXXXXXXXXX ${PAPPSOMSPP_WIDGET_QT5_LIBRARY} XXXXXXXXXXXXXXX")
    SET(PAPPSOMSPP_WIDGET_QT5_FOUND TRUE)
    ENDIF (PAPPSOMSPP_INCLUDE_DIR AND PAPPSOMSPP_WIDGET_QT5_LIBRARY)
  
ENDIF (PAPPSOMSPP_QT5_FOUND)


IF (PAPPSOMSPP_QT5_FOUND)
  # show which CppUnit was found only if not quiet
  IF (NOT PAPPSOMSPP_FIND_QUIETLY)
    MESSAGE(STATUS "Found PAPPSOMSPP_WIDGET_QT5_LIBRARY for Qt5: ${PAPPSOMSPP_WIDGET_QT5_LIBRARY}")
  ENDIF (NOT PAPPSOMSPP_FIND_QUIETLY)
ENDIF (PAPPSOMSPP_QT5_FOUND)

IF (NOT PAPPSOMSPP_QT4_FOUND)
  IF (NOT PAPPSOMSPP_QT5_FOUND)
    # fatal error if CppUnit is required but not found
    IF (PAPPSOMSPP_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR "Could not find PAPPSOMSPP Qt4 or Qt5 please do specify the PAPPSOMSPP_INCLUDE_DIR, PAPPSOMSP_QT4_LIBRARY and  PAPPSOMSP_QT5_LIBRARY variables using ccmake!")
    ENDIF (PAPPSOMSPP_FIND_REQUIRED)
  ENDIF (NOT PAPPSOMSPP_QT5_FOUND)
ENDIF (NOT PAPPSOMSPP_QT4_FOUND)
