#ifndef _COMMON_H
#define _COMMON_H


#include <QDebug>
#include <pappsomspp/spectrum/spectrum.h>
#include <pwiz/data/msdata/MSDataFile.hpp>

using namespace pappso;

Spectrum readMgf(const QString & filename) {
    std::string env;
    env=setlocale(LC_ALL,"");
    struct lconv * lc = localeconv ();
    qDebug() << " env=" << env.c_str() << " lc->decimal_point " << lc->decimal_point;
    setlocale(LC_ALL,"C");
    lc = localeconv ();
    qDebug() << "opening file " << filename << " lc->decimal_point " << lc->decimal_point;
    pwiz::msdata::MSDataFile dataFile(filename.toStdString());
    const bool getBinaryData = true;
    pwiz::msdata::SpectrumPtr simple_spectrum_pwiz = dataFile.run.spectrumListPtr.get()->spectrum(0, getBinaryData);
    // fill in MZIntensityPair vector for convenient access to binary data
    vector<pwiz::msdata::MZIntensityPair> pairs;
    simple_spectrum_pwiz->getMZIntensityPairs(pairs);
    // cout << "spectrum_simple size:" << pairs.size() << endl;

    Spectrum spectrum;

    // iterate through the m/z-intensity pairs
    for (vector<pwiz::msdata::MZIntensityPair>::const_iterator it=pairs.begin(), end=pairs.end(); it!=end; ++it)
    {
        spectrum.push_back(Peak(it->mz, it->intensity));
    }
    //cout << "spectrum_simple size  " << spectrum_simple.getSpectrumSize()<< endl;
    setlocale(LC_ALL,env.c_str());
    return std::move(spectrum);
}

#endif /* _COMMON_H */
