
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/
#include "xicfiltersmoothing.h"

#include <numeric>

namespace pappso {


pappso_double
get_average(std::vector<XicElement>::const_iterator beginit, std::vector<XicElement>::const_iterator endit) {
    pappso_double nb_element = distance(beginit, endit);
    pappso_double sum(0), result(0);
    if (nb_element != 0) {
        const pappso_double init_accumul= 0;
        sum = std::accumulate(beginit, endit, init_accumul,[](const pappso_double& a, XicElement b) {
            return a+b.intensity;
        });
        result = sum / nb_element;
    }
    return result;
}


XicFilterSmoothing::XicFilterSmoothing()
{

}

XicFilterSmoothing::~XicFilterSmoothing()
{

}
void XicFilterSmoothing::filterInternal (const Xic & xic, Xic & newxic) const {
    xic.newXicByApplyingWindowsOperation(_smoothing_half_window_length,&get_average, newxic);
}
}
