/**
 * \file pappsomspp/psm/xtandem/xtandemhyperscorebis.h
 * \date 8/9/2016
 * \author Olivier Langella
 * \brief computation of the X!Tandem hyperscore
 */

/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#ifndef XTANDEMHYPERSCOREBIS_H
#define XTANDEMHYPERSCOREBIS_H

#include "../../spectrum/spectrum.h"
#include "../../peptide/peptide.h"

namespace pappso {
class XtandemHyperscoreBis
{
public:
    using AaFactorMap = std::map<char, pappso_double>;
    XtandemHyperscoreBis(bool refine_spectrum_synthesis, PrecisionP precision,  const std::vector<PeptideIon> & ion_list);
    ~XtandemHyperscoreBis();

    pappso_double getHyperscore() const;
    unsigned int getMatchedIons(PeptideIon ion_type) const;


    void reset();

    bool computeXtandemHyperscore(const Spectrum & spectrum, const Peptide & peptide, unsigned int parent_charge );
    unsigned int getTotalMatchedIons() const;
private :
    unsigned int getXtandemPredictedIonIntensityFactor(const QString & sequence, PeptideIon ion_type, unsigned int size) const;

    bool _refine_spectrum_synthesis;
    PrecisionP _precision;
    std::vector<PeptideIon> _ion_list;

    unsigned int _total_matched_ions = 0;
    unsigned int _ion_count[20] =
    {   [(std::int8_t)PeptideIon::b] = 0,
        [(std::int8_t)PeptideIon::bstar] = 0,
        [(std::int8_t)PeptideIon::bo] = 0,
        [(std::int8_t)PeptideIon::a] = 0,
        [(std::int8_t)PeptideIon::astar] = 0,
        [(std::int8_t)PeptideIon::ao] = 0,
        [(std::int8_t)PeptideIon::bp] = 0,
        [(std::int8_t)PeptideIon::c] = 0,
        [(std::int8_t)PeptideIon::y] = 0,
        [(std::int8_t)PeptideIon::ystar] = 0,
        [(std::int8_t)PeptideIon::yo] = 0,
        [(std::int8_t)PeptideIon::z] = 0,
        [(std::int8_t)PeptideIon::yp] = 0,
        [(std::int8_t)PeptideIon::x] = 0
    };


    pappso_double _proto_hyperscore;

    static AaFactorMap _aa_ion_factor_y;
    static AaFactorMap _aa_ion_factor_b;


};
}
#endif // XTANDEMHYPERSCOREBIS_H
