/**
 * \file pappsomspp/psm/peptidespectrummatch.h
 * \date 2/4/2015
 * \author Olivier Langella
 * \brief find peaks matching between ions and spectrum
 */

/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#ifndef PEPTIDESPECTRUMMATCH_H
#define PEPTIDESPECTRUMMATCH_H


#include "../spectrum/spectrum.h"
#include "../mass_range.h"
#include "../peptide/peptidefragmention.h"
#include "../peptide/peptidefragmentionlistbase.h"
#include "peakionmatch.h"

namespace pappso {
class PeptideSpectrumMatch
{
public:
    PeptideSpectrumMatch(const Spectrum & spectrum, pappso::PeptideSp peptideSp, unsigned int parent_charge, PrecisionP precision, std::list<PeptideIon> ion_list);
    PeptideSpectrumMatch(const Spectrum & spectrum,const PeptideFragmentIonListBase & peptide_fragment_ion_list, unsigned int parent_charge, PrecisionP precision, std::list<PeptideIon> ion_list);
    PeptideSpectrumMatch(const Spectrum & spectrum,std::vector<PeptideFragmentIonSp> & v_peptide_fragment_ion,  std::vector<unsigned int> & v_peptide_fragment_ion_charge, PrecisionP precision);
    PeptideSpectrumMatch(const PeptideSpectrumMatch& other);

    ~PeptideSpectrumMatch();

    bool contains(PeptideFragmentIonSp peptideFragmentIonSp, unsigned int z) const;

    typedef std::list<PeakIonMatch>::const_iterator const_iterator;

    unsigned int size() const {
        return _peak_ion_match_list.size();
    }
    const_iterator begin() const {
        return _peak_ion_match_list.begin();
    }
    const_iterator end() const {
        return _peak_ion_match_list.end();
    }

private :
    void privMatchIonList(const Spectrum & spectrum, const PeptideFragmentIonListBase & fragmentIonList, unsigned int max_charge, std::list<PeptideIon> ion_type_list);

    virtual std::list<Peak>::iterator getBestPeakIterator (std::list<Peak> & peak_list, const PeptideFragmentIonSp & ion,unsigned int charge) const;


private :
    PrecisionP _precision;

    std::list<PeakIonMatch> _peak_ion_match_list;
};
}
#endif // PEPTIDESPECTRUMMATCH_H
