/*
 * /*******************************************************************************
 * * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 * *
 * * This file is part of MassChroqPRM.
 * *
 * *     MassChroqPRM is free software: you can redistribute it and/or modify
 * *     it under the terms of the GNU General Public License as published by
 * *     the Free Software Foundation, either version 3 of the License, or
 * *     (at your option) any later version.
 * *
 * *     MassChroqPRM is distributed in the hope that it will be useful,
 * *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 * *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * *     GNU General Public License for more details.
 * *
 * *     You should have received a copy of the GNU General Public License
 * *     along with MassChroqPRM.  If not, see <http://www.gnu.org/licenses/>.
 * *
 * * Contributors:
 * *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 * ******************************************************************************/


#include "peptideisotopespectrummatch.h"

namespace pappso {
PeptideIsotopeSpectrumMatch::PeptideIsotopeSpectrumMatch(const Spectrum & spectrum, const PeptideSp & peptideSp, unsigned int parent_charge,PrecisionP precision, std::list<PeptideIon> ion_type_list, unsigned int maxIsotopeLevel, unsigned int maxIsotopeRank)
    :_precision(precision)
{

    PeptideFragmentIonListBase fragmentIonList(peptideSp, ion_type_list);
    std::list<Peak> peak_list(spectrum.begin(), spectrum.end());

    for (auto ion_type: ion_type_list) {
        auto ion_list = fragmentIonList.getPeptideFragmentIonSp(ion_type);

        for (unsigned int charge=1; charge <= parent_charge; charge++) {
            for (auto && ion : ion_list) {
                unsigned int askedIsotopeRank = 1;
                for (unsigned int isotopeLevel=0; isotopeLevel <= maxIsotopeLevel; isotopeLevel++) {
                    PeptideNaturalIsotopeAverage isotopeIon(ion, askedIsotopeRank, isotopeLevel, charge, precision);

                    std::list<Peak>::iterator it_peak = getBestPeakIterator (peak_list, isotopeIon);
                    if (it_peak != peak_list.end()) {
                        _peak_ion_match_list.push_back(PeakIonIsotopeMatch(*it_peak,isotopeIon.makePeptideNaturalIsotopeAverageSp(), ion));
                        peak_list.erase(it_peak);
                    }
                }
            }
        }
    }

}

PeptideIsotopeSpectrumMatch::PeptideIsotopeSpectrumMatch(const Spectrum & spectrum, std::vector<PeptideNaturalIsotopeAverageSp> v_peptideIsotopeList, std::vector<PeptideFragmentIonSp> v_peptideIonList, PrecisionP precision)
    :_precision(precision)
{
    qDebug() << "PeptideIsotopeSpectrumMatch::PeptideIsotopeSpectrumMatch begin";
    if (v_peptideIsotopeList.size() != v_peptideIonList.size()) {
        throw PappsoException(QObject::tr("v_peptideIsotopeList.size() %1 != v_peptideIonList.size() %2").arg(v_peptideIsotopeList.size()).arg(v_peptideIonList.size()));
    }
  
    auto isotopeIt = v_peptideIsotopeList.begin();
    auto ionIt = v_peptideIonList.begin();
    std::list<Peak> peak_list(spectrum.begin(), spectrum.end());

    while (isotopeIt != v_peptideIsotopeList.end()) {
        std::list<Peak>::iterator it_peak = getBestPeakIterator (peak_list, *(isotopeIt->get()));
        if (it_peak != peak_list.end()) {
            _peak_ion_match_list.push_back(PeakIonIsotopeMatch(*it_peak,*isotopeIt, *ionIt));
            peak_list.erase(it_peak);
        }
        isotopeIt++;
        ionIt++;
    }
    qDebug() << "PeptideIsotopeSpectrumMatch::PeptideIsotopeSpectrumMatch end";

}


PeptideIsotopeSpectrumMatch::PeptideIsotopeSpectrumMatch(const PeptideIsotopeSpectrumMatch& other):_precision(other._precision), _peak_ion_match_list(other._peak_ion_match_list)
{

}

PeptideIsotopeSpectrumMatch::~PeptideIsotopeSpectrumMatch()
{

}


std::list<Peak>::iterator PeptideIsotopeSpectrumMatch::getBestPeakIterator (std::list<Peak> & peak_list, const PeptideNaturalIsotopeAverage & ion) const {
   qDebug() << "PeptideIsotopeSpectrumMatch::getBestPeakIterator begin";
    std::list<Peak>::iterator itpeak = peak_list.begin();
    std::list<Peak>::iterator itend = peak_list.end();
    std::list<Peak>::iterator itselect = peak_list.end();

    pappso_double best_intensity = 0;

    while (itpeak != itend) {
        if (ion.matchPeak(itpeak->mz)) {
            if (itpeak->intensity > best_intensity) {
                best_intensity = itpeak->intensity;
                itselect = itpeak;
            }
        }
        itpeak++;
    }
     qDebug() << "PeptideIsotopeSpectrumMatch::getBestPeakIterator end";
    return(itselect);
}

}
