
/*******************************************************************************
 * Copyright (c) 2016 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#ifndef PEPTIDEFIXEDMODIFICATIONBUILDER_H
#define PEPTIDEFIXEDMODIFICATIONBUILDER_H

#include "peptidemodificatorbase.h"

namespace pappso {

class PeptideFixedModificationBuilder: public PeptideModificatorBase
{
public:
    PeptideFixedModificationBuilder(AaModificationP p_mod);
    ~PeptideFixedModificationBuilder();
    void setPeptideSp(std::int8_t sequence_database_id, const ProteinSp & protein_sp, bool is_decoy, const PeptideSp & peptide_sp_original, unsigned int start, bool is_nter, unsigned int missed_cleavage_number, bool semi_enzyme) override;

    void addAa(char aa);

    void setSink (PeptideModificatorInterface * sink) override {
        _sink = sink;
    };
    /** \brief this modification concerns the Nter peptide
     * */
    void setProtNter(bool arg1) {
        _prot_nter_mod=arg1;
    };
    /** \brief this modification concerns the Cter peptide
     * */
    void setProtCter(bool arg1) {
        _prot_cter_mod=arg1;
    };
    /** \brief this modification concerns all peptides between Nter and Cter
     * */
    void setProtElse(bool arg1) {
        _prot_else_mod=arg1;
    };


private :
    PeptideModificatorInterface * _sink=nullptr;

    const AaModificationP _p_mod;

    //protein Nter modification
    bool _prot_nter_mod = true;
    //protein Cter modification
    bool _prot_cter_mod = true;
    //all peptide between Nter and Cter
    bool _prot_else_mod = true;

    QString _aa_modification_list;

};
}
#endif // PEPTIDEFIXEDMODIFICATIONBUILDER_H
