
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#include "enzyme.h"
#include <QStringList>
#include <QDebug>

namespace pappso {
Enzyme::Enzyme()
{
    _recognition_site.setPattern("([KR])([^P])");
    _miscleavage=0;
}

Enzyme::Enzyme(const QString & recognition_site)
{
    _recognition_site.setPattern(recognition_site);
    _miscleavage=0;
}

Enzyme::~Enzyme()
{

}

void Enzyme::eat(std::int8_t sequence_database_id, const ProteinSp & protein_sp, bool is_decoy, EnzymeProductInterface & enzyme_product) const {
    /*
     *        for aa in self.aa_to_cut:
              seq = seq.replace(aa, aa + ' ')
          seq_stack = []
          for s in seq.strip().split(' '):
              seq_stack.append(s)
              if len(seq_stack) > self.misscleavage + 1:
                  seq_stack.pop(0)
              s2 = ""
              for s_miss in seq_stack[::-1]:
                  s2 = s_miss + s2
                  yield s2
    */
    qDebug() << "Enzyme::eat begin ";
    const QString sequence = protein_sp.get()->getSequence();
    qDebug() << sequence;
    QStringList peptide_list;
    int pos = 0;
    int peptide_start = 0;
    int peptide_size = sequence.size();
    while ((pos = _recognition_site.indexIn(sequence, pos)) != -1) {
        peptide_size = pos + _recognition_site.cap(1).length()-peptide_start;
        //qDebug() << "pos=" << pos << " peptide_start=" << peptide_start << " peptide_size=" << peptide_size << " " << sequence.mid(peptide_start,peptide_size);
        if (peptide_size > 0) {
            peptide_list.append(sequence.mid(peptide_start,peptide_size));
        }
        peptide_start+= peptide_size;
        pos= peptide_start;//all peptides MUST be consecutive
    }
    peptide_size = sequence.size()- peptide_start;
    if (peptide_size > 0) {
        peptide_list.append(sequence.mid(peptide_start,peptide_size));
    }

    unsigned int start=1;
    bool is_nter = true;
    foreach (const QString &peptide, peptide_list) {
        enzyme_product.setPeptide(sequence_database_id, protein_sp,is_decoy, peptide, start,is_nter,0, false);
        is_nter = false;
        start += peptide.size();
    }

    unsigned int miscleavage_i = 0;
    while (miscleavage_i < _miscleavage) {
        miscleavage_i++;
        qDebug() << "miscleavage_i=" << miscleavage_i;
        unsigned int chunk_number= miscleavage_i+1;
        unsigned int start=1;
        bool is_nter = true;

        for (unsigned int i = 0; i < peptide_list.size(); ++i) {
            qDebug() << "start=" << start;
            QStringList peptide_mis_list;
            for (unsigned int j = 0; (j < chunk_number) && ((i+j) < peptide_list.size()); j++) {
                peptide_mis_list << peptide_list.at(i+j);
            }
            if(peptide_mis_list.size() == chunk_number) {
                enzyme_product.setPeptide(sequence_database_id, protein_sp,is_decoy, peptide_mis_list.join(""), start,is_nter, miscleavage_i, false);
            }
            is_nter = false;
            start += peptide_list.at(i).size();
        }
    }
}

}
