/**
 * \file pappsomspp/peptide/peptidenaturalisotopelist.h
 * \date 8/3/2015
 * \author Olivier Langella
 * \brief peptide natural isotope model
 */

/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#ifndef PEPTIDENATURALISOTOPELIST_H
#define PEPTIDENATURALISOTOPELIST_H

#include<list>
#include"peptidenaturalisotope.h"

#include "peptidenaturalisotopeaverage.h"

namespace pappso {

class PeptideNaturalIsotopeList;
typedef std::shared_ptr<const PeptideNaturalIsotopeList> PeptideNaturalIsotopeListSp;

class PeptideNaturalIsotopeList
{
public:
    PeptideNaturalIsotopeList(const PeptideInterfaceSp & peptide, pappso_double minimu_ratio_to_compute = 0.001);
    PeptideNaturalIsotopeList(const PeptideNaturalIsotopeList& other);
    ~PeptideNaturalIsotopeList();
    PeptideNaturalIsotopeListSp makePeptideNaturalIsotopeListSp() const;

    typedef std::list<PeptideNaturalIsotopeSp>::const_iterator const_iterator;

    const_iterator begin() const {
        return _peptide_natural_isotope_list.begin();
    }

    const_iterator end() const {
        return _peptide_natural_isotope_list.end();
    }

    const std::map<unsigned int, pappso_double> getIntensityRatioPerIsotopeNumber() const;
    std::vector<PeptideNaturalIsotopeSp> getByIsotopeNumber(unsigned int isotopeLevel, unsigned int charge) const;
    std::vector<PeptideNaturalIsotopeAverageSp> getByIntensityRatio(unsigned int charge, PrecisionP precision, pappso_double minimumIntensity) const;


    unsigned int size() const {
        return _peptide_natural_isotope_list.size();
    }
    const PeptideInterfaceSp & getPeptideInterfaceSp() const {
        return _peptide;
    }
private :
    const PeptideInterfaceSp _peptide;
    std::list<PeptideNaturalIsotopeSp> _peptide_natural_isotope_list;
};
}

#endif // PEPTIDENATURALISOTOPELIST_H
