
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#ifndef OBOPSIMOD_H
#define OBOPSIMOD_H

#include<QRegExp>
#include "../types.h"

namespace pappso {

class OboPsiMod;

class OboPsiModTerm {
    friend OboPsiMod;
public:
    bool isValid() const {
        return (!_accession.isEmpty());
    };
public:
    QString _accession;
    QString _name;
    QString _psi_mod_label;
    QString _psi_ms_label;
    QString _diff_formula;

    mz _diff_mono;

private :
    void parseLine(const QString & line);
    void clearTerm();

    static QRegExp _first_parse;
    static QRegExp _find_exact_psimod_label;
    static QRegExp _find_related_psims_label;


};

class OboPsiModHandlerInterface
{
public:
    virtual void setOboPsiModTerm (const OboPsiModTerm & term) = 0;
};

class OboPsiMod
{
public:
    OboPsiMod(OboPsiModHandlerInterface & handler);
    ~OboPsiMod();

private :
    void parse();

private:
    OboPsiModTerm _term;
    OboPsiModHandlerInterface & _handler;

};
}
#endif // OBOPSIMOD_H
