
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#include "msrunid.h"
#include "../utils.h"

namespace pappso {


QMutex MsRunId::_smutex; // Before all
unsigned int MsRunId::_count = []
{
    return 0;
}();


MsRunId::MsRunId(const QString & filename): _filename(filename)
{
    QMutexLocker locker(&_smutex);
    _count++;
    _xml_id = QString("sample%1").arg(Utils::getLexicalOrderedString(_count));
}

MsRunId::MsRunId()
{

}

MsRunId::MsRunId(const MsRunId& other)
    : _filename(other._filename)
{
    _xml_id = other._xml_id;
}


MsRunIdSp MsRunId::makeMsRunIdSp() const {
    return std::make_shared<const MsRunId>(*this);
}

MsRunId::~MsRunId()
{

}

bool MsRunId::operator==(const MsRunId& other) const
{
    if (_xml_id == other._xml_id) return true;
    return false;

}
MsRunId& MsRunId::operator=(const MsRunId& other)
{
    _filename = other._filename;
    _xml_id = other._xml_id;
}
}
