
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/
#include <QDebug>
#include "grpmappeptidetosubgroupset.h"
#include "grppeptideset.h"

#include "../pappsoexception.h"


namespace pappso {
GrpMapPeptideToSubGroupSet::GrpMapPeptideToSubGroupSet()
{

}

GrpMapPeptideToSubGroupSet::~GrpMapPeptideToSubGroupSet()
{

}
void GrpMapPeptideToSubGroupSet::getSubGroupSet(const GrpPeptideSet & peptide_set_in, GrpSubGroupSet & impacted_subgroup_set) const {
    qDebug() << "GrpMapPeptideToSubGroupSet::getSubGroupSet begin " ;
    auto itPeptide = peptide_set_in._list_p_peptide.begin();
    auto itPeptideEnd = peptide_set_in._list_p_peptide.end();
    auto itMap = _map_peptide2subgroup_set.begin();
    auto itMapEnd = _map_peptide2subgroup_set.end();


    while ((itMap != itMapEnd) && (itPeptide != itPeptideEnd)) {
        if (*itPeptide > itMap->first) {
            itMap++;
            continue;
        }
        if (*itPeptide < itMap->first) {
            itPeptide++;
            continue;
        }
        if (*itPeptide == itMap->first) {
            //get related subgroup _list
            impacted_subgroup_set.addAll(itMap->second);
            itPeptide++;
        }
        itMap++;
    }
    qDebug() << "GrpMapPeptideToSubGroupSet::getSubGroupSet end " ;

}
void GrpMapPeptideToSubGroupSet::check(std::list< GrpSubGroupSp > & _subgroup_list)const {
    qDebug() << "GrpMapPeptideToSubGroupSet::std begin " ;
    GrpMapPeptideToSubGroupSet test(*this);
    qDebug() << "GrpMapPeptideToSubGroupSet::std before test.size() " << test.size();

    for (auto pair : _map_peptide2subgroup_set) {
        qDebug() << "GrpMapPeptideToSubGroupSet::std before peptide " << pair.first->getSequence() << " "<< pair.first;
    }

    for (GrpSubGroupSp & sub_group_sp : _subgroup_list) {
        test.remove(sub_group_sp.get());
    }
    qDebug() << "GrpMapPeptideToSubGroupSet::std after test.size() " << test.size();

    qDebug() << "GrpMapPeptideToSubGroupSet::std begin " ;
}

void GrpMapPeptideToSubGroupSet::remove(GrpSubGroup* p_remove_sub_group) {
    qDebug() << "GrpMapPeptideToSubGroupSet::remove begin " << p_remove_sub_group->getFirstAccession();
    //std::list<std::pair<GrpPeptide*, GrpSubGroupSet>> _map_peptide2subgroup_set;
    const GrpPeptideSet & peptide_set_in = p_remove_sub_group->getPeptideSet();
    /*
          for (auto pep : peptide_set_in._list_p_peptide) {
    qDebug() << "GrpMapPeptideToSubGroupSet::std before peptide " << pep->getSequence() << " "<< pep;
      }
    */
    auto itPeptide = peptide_set_in._list_p_peptide.begin();
    auto itPeptideEnd = peptide_set_in._list_p_peptide.end();
    auto itMap = _map_peptide2subgroup_set.begin();
    auto itMapEnd = _map_peptide2subgroup_set.end();


    while ((itMap != itMapEnd) && (itPeptide != itPeptideEnd)) {
        if (*itPeptide > itMap->first) {
            itMap++;
            continue;
        }
        if (*itPeptide < itMap->first) {
            //this is a bug
            throw PappsoException(QObject::tr("remove ERROR, peptide %1 from subgroup %2 not referenced in GrpMapPeptideToSubGroupSet").arg((*itPeptide)->getSequence()).arg(p_remove_sub_group->getFirstAccession()));
        }
        if (*itPeptide == itMap->first) {
            itMap->second.remove(p_remove_sub_group);
            itPeptide++;
            if (itMap->second.size() == 0) {
                //throw PappsoException(QObject::tr("remove ERROR, removing subgroup %2 totally remove %1 in GrpMapPeptideToSubGroupSet").arg((*itPeptide)->getSequence()).arg(p_remove_sub_group->getFirstAccession()));
                itMap = _map_peptide2subgroup_set.erase(itMap);
                continue;
            }
        }
        itMap++;
    }
    if(itPeptide != itPeptideEnd) {
        throw PappsoException(QObject::tr("remove ERROR, peptide %1, subgroup %2, not removed from GrpMapPeptideToSubGroupSet").arg((*itPeptide)->getSequence()).arg(p_remove_sub_group->getFirstAccession()));
    }
    qDebug() << "GrpMapPeptideToSubGroupSet::remove end " << p_remove_sub_group->getFirstAccession();

}
void GrpMapPeptideToSubGroupSet::add(GrpSubGroup* p_add_sub_group) {
    qDebug() << "GrpMapPeptideToSubGroupSet::add begin  _map_peptide2subgroup_set.size()" <<  _map_peptide2subgroup_set.size();
    //std::list<std::pair<GrpPeptide*, GrpSubGroupSet>> _map_peptide2subgroup_set;
    auto itPeptide = p_add_sub_group->getPeptideSet()._list_p_peptide.begin();
    auto itPeptideEnd = p_add_sub_group->getPeptideSet()._list_p_peptide.end();
    auto itMap = _map_peptide2subgroup_set.begin();
    auto itMapEnd = _map_peptide2subgroup_set.end();

    GrpSubGroupSet sg_set;
    qDebug() << "GrpMapPeptideToSubGroupSet::add 1";
    sg_set.add(p_add_sub_group);
    qDebug() << "GrpMapPeptideToSubGroupSet::add 2";
    while ((itMap != itMapEnd) && (itPeptide != itPeptideEnd)) {
        if (*itPeptide > itMap->first) {
            itMap++;
            continue;
        }
        if (*itPeptide < itMap->first) {
            //this is a new peptide : create a pair and insert it
            qDebug() << "GrpMapPeptideToSubGroupSet::add " << (*itPeptide)->getSequence() << " "<< *itPeptide;
            qDebug() << "GrpMapPeptideToSubGroupSet::add itMap " << itMap->first->getSequence() << " "<< itMap->first;
            qDebug() << "GrpMapPeptideToSubGroupSet::add itMap-- " << itMap->first->getSequence() << " "<< itMap->first;
            //std::pair<GrpPeptide*, GrpSubGroupSet> my_pair(*itPeptide,sg_set);
            itMap = _map_peptide2subgroup_set.insert(itMap, std::pair<GrpPeptide*, GrpSubGroupSet>(*itPeptide,sg_set));
            itMap++;
            itPeptide++;
            continue;
        }
        if (*itPeptide == itMap->first) {
            itMap->second.add(p_add_sub_group);
            itPeptide++;
            itMap++;
        }
    }
    qDebug() << "GrpMapPeptideToSubGroupSet::add finish _map_peptide2subgroup_set p_add_sub_group->getPeptideSet().size() " <<  p_add_sub_group->getPeptideSet().size();
    while (itPeptide != itPeptideEnd) {
        qDebug() << "GrpMapPeptideToSubGroupSet::add _map_peptide2subgroup_set.size() " << _map_peptide2subgroup_set.size() << " " << (*itPeptide)->getSequence() << " " << p_add_sub_group->getFirstAccession();
        itMap =_map_peptide2subgroup_set.insert(itMap, std::pair<GrpPeptide*, GrpSubGroupSet>(*itPeptide,sg_set));
        itMap++;
        itPeptide++;
    }
    qDebug() << "GrpMapPeptideToSubGroupSet::add end";

}


bool GrpMapPeptideToSubGroupSet::hasSpecificPeptide(const GrpSubGroup* p_sub_group) const {
    qDebug() << "GrpMapPeptideToSubGroupSet::hasSpecificPeptide begin";
    auto itPeptide = p_sub_group->getPeptideSet()._list_p_peptide.begin();
    auto itPeptideEnd = p_sub_group->getPeptideSet()._list_p_peptide.end();
    auto itMap = _map_peptide2subgroup_set.begin();
    auto itMapEnd = _map_peptide2subgroup_set.end();

    while ((itMap != itMapEnd) && (itPeptide != itPeptideEnd)) {
        if (*itPeptide > itMap->first) {
            itMap++;
            continue;
        }
        if (*itPeptide < itMap->first) {
            //this is a bug
            throw PappsoException(QObject::tr("peptide %1 from subgroup %2 not referenced in GrpMapPeptideToSubGroupSet").arg((*itPeptide)->getSequence()).arg(p_sub_group->getFirstAccession()));
        }
        if (*itPeptide == itMap->first) {
            if (itMap->second.size() == 1) {

                qDebug() << "GrpMapPeptideToSubGroupSet::hasSpecificPeptide end";
                return true;
            }
            itPeptide++;
            itMap++;
        }
    }
    if(itPeptide != itPeptideEnd) {
        throw PappsoException(QObject::tr("hasSpecificPeptide ERROR, peptide %1, subgroup %2, not referenced in GrpMapPeptideToSubGroupSet").arg((*itPeptide)->getSequence()).arg(p_sub_group->getFirstAccession()));
    }

    qDebug() << "GrpMapPeptideToSubGroupSet::hasSpecificPeptide end";
    return false;
}

const QString GrpMapPeptideToSubGroupSet::printInfos() const {
    QString infos;
    auto itMap = _map_peptide2subgroup_set.begin();
    auto itMapEnd = _map_peptide2subgroup_set.end();

    while (itMap != itMapEnd) {
      infos.append(itMap->first->getSequence()+" "+QString("0x%1").arg((quintptr) itMap->first, 
                    QT_POINTER_SIZE * 2, 16, QChar('0'))+"\n");
        itMap++;

    }

    return infos;
}

}
