
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/
#include "xicfilterspike.h"

namespace pappso {


pappso_double
get_spike_to_zero(std::vector<XicElement>::const_iterator beginit, std::vector<XicElement>::const_iterator endit) {
    //check if other values are 0
    unsigned long nb_element = std::distance(beginit, endit);
    std::vector<XicElement>::const_iterator centerit;
    if (nb_element % 2 == 0) {
        centerit = beginit + (nb_element / 2) - 1;
    } else {
        centerit = beginit + (nb_element / 2);
    }
    if ((centerit->intensity) > 0) {
        unsigned long num_items = count_if(beginit, endit, [](XicElement n) {
            return n.intensity == 0;
        } );
        if (num_items == (nb_element - 1)) {
            return (0);
        }
    }
    return (centerit->intensity);
}


XicFilterSpike::XicFilterSpike()
{
}

void XicFilterSpike::filterInternal (const Xic & xic, Xic & newxic) const {
    xic.newXicByApplyingWindowsOperation(_half_edge_windows,&get_spike_to_zero, newxic);
}

}
