
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/
#include "xicdetectionmoulon.h"

namespace pappso {
XicDetectionMoulon::XicDetectionMoulon()
{

}


void XicDetectionMoulon::detect (const Xic & xic,XicDetectionSinkInterface * p_sink) const {
    if (p_sink != nullptr) {

        Xic xic_smoothed;

        _smooth.filter(xic,&xic_smoothed);

        // detect peaks :
        bool banked(false);
        unsigned int nb_tic_start(0);

        std::vector<XicElement>::const_iterator it_smoothed ;
        std::vector<XicElement>::const_iterator it ;

        XicPeak * p_current_peak = nullptr;

        for ( it_smoothed = xic_smoothed.begin(), it = xic.begin();
                it_smoothed != xic_smoothed.end();
                ++it_smoothed, ++it)
        {

            if ((nb_tic_start == 0)
                    && (p_current_peak != nullptr)
                    && (banked == false))
            {
                delete (p_current_peak);
                p_current_peak = nullptr;
            }

            if (it_smoothed->intensity >= _tic_start)
            {
                nb_tic_start++;
                if (p_current_peak == nullptr) {
                    p_current_peak = new XicPeak;
                    p_current_peak->setLeftBoundary(*it_smoothed);
                    banked = false;
                }
                if ((nb_tic_start == 2) && (banked == false))
                {
                    banked = true;
                }
            } else
            {
                nb_tic_start = 0;
            }
            if (p_current_peak != nullptr)
            {
                p_current_peak->integrateXicElement(*(it-1), *it);
                //current_peak->add_measure(rtime, intensity);
            }
            if (it_smoothed->intensity <= _tic_stop)
            {
                if (p_current_peak != nullptr)
                {

                    if (banked) p_sink->setXicPeak(*p_current_peak);
                    delete (p_current_peak);
                    p_current_peak = nullptr;
                    banked = false;
                }
            }
        }
    }
}
}
