
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/
#ifndef SPECTRUMID_H
#define SPECTRUMID_H

#include "../msrun/msrunid.h"
#include <QString>

namespace pappso {
class SpectrumId
{
public:
    SpectrumId(const MsRunId & msrun_id, unsigned int scan_num);
    SpectrumId();
    SpectrumId(const SpectrumId& other);
    ~SpectrumId();
    bool operator==(const SpectrumId& other) const;
    SpectrumId& operator=(const SpectrumId& other);


    void setMsRunId(const MsRunId & other_msrun_id) {
        _msrun_id = other_msrun_id;
    };
    const MsRunId & getMsRunId() const {
        return _msrun_id;
    };
    unsigned long getScanNum() const {
        return _scan_num;
    };

private :
    MsRunId _msrun_id;
    unsigned long _scan_num=0;
};
}
#endif // SPECTRUMID_H
