
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/
#include "spectrumid.h"

namespace pappso {
SpectrumId::SpectrumId(const MsRunId & msrun_id, unsigned int scan_num): _msrun_id(msrun_id), _scan_num(scan_num)
{

}
SpectrumId::SpectrumId()
{

}

SpectrumId::SpectrumId(const SpectrumId& other)
: _msrun_id(other._msrun_id), _scan_num(other._scan_num)
{

}

SpectrumId::~SpectrumId()
{

}

SpectrumId& SpectrumId::operator=(const SpectrumId& other)
{
  _scan_num = other._scan_num;
  _msrun_id = other._msrun_id;
}

bool SpectrumId::operator==(const SpectrumId& other) const
{
  if ((_scan_num == other._scan_num) && (_msrun_id == other._msrun_id)) return true;
  return false;
}
}