/**
 * \file pappsomspp/psm/xtandem/xtandemhyperscore.h
 * \date 16/8/2016
 * \author Olivier Langella
 * \brief process spectrum to compute X!Tandem hyperscore
 */

/*******************************************************************************
 * Copyright (c) 2016 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#ifndef XTANDEMSPECTRUMPROCESS_H
#define XTANDEMSPECTRUMPROCESS_H

#include "../../spectrum/spectrum.h"
#include "../../peptide/peptide.h"

namespace pappso {
class XtandemSpectrumProcess
{
public:
    XtandemSpectrumProcess();
    XtandemSpectrumProcess(const XtandemSpectrumProcess & copy);
    ~XtandemSpectrumProcess();

    /** \brief process raw spectrum to prepare hyperscore computation
     */
    Spectrum process (const Spectrum & spectrum,mz parent_ion_mass, unsigned int parent_charge) const;
    void setMinimumMz(pappso::mz minimum_mz);
    void setNmostIntense(unsigned int nmost_intense);
    void setDynamicRange(pappso::pappso_double dynamic_range);
    void setRemoveIsotope(bool remove_isotope);
    void setExcludeParent(bool exclude_parent);
    void setExcludeParentNeutralLoss(bool neutral_loss);
    void setNeutralLossMass(pappso::pappso_double neutral_loss_mass);
    void setNeutralLossWindowDalton(pappso::pappso_double neutral_loss_precision);
    void setRefineSpectrumModel(bool refine);
    void setIonScore(PeptideIon ion_type, bool compute_score);

    pappso::mz getMinimumMz() const;
    unsigned int getNmostIntense() const;
    pappso::pappso_double getDynamicRange() const;
    bool getRemoveIsotope() const;
    bool getExcludeParent() const;
    bool getExcludeParentNeutralLoss() const;
    pappso::pappso_double getNeutralLossMass() const;
    pappso::pappso_double getNeutralLossWindowDalton() const;
    bool getRefineSpectrumModel() const;
    bool getIonScore(PeptideIon ion_type) const;

private:
    //    Spectrum spectrum_simple = _spectrum.getOriginalSpectrumSp()->applyCutOff(150).takeNmostIntense(100).applyDynamicRange(100);
    pappso::mz _minimum_mz =150;
    unsigned int _nmost_intense=100;
    pappso::pappso_double _dynamic_range = 100;
    bool _remove_isotope =true;
    bool _exclude_parent = false;
    pappso::pappso_double _exclude_parent_lower_dalton = 2;
    pappso::pappso_double _exclude_parent_upper_dalton = 2;
    bool _exclude_parent_neutral_loss = false;
    pappso::pappso_double _neutral_loss_mass = MASSH2O;
    pappso::pappso_double _neutral_loss_window_dalton = 0.5;
    bool _refine_spectrum_model = true;
    bool _y_ions = true; //PeptideIon::y
    bool _ystar_ions = false; //PeptideIon::ystar
    bool _b_ions = true; //PeptideIon::b
    bool _bstar_ions = false; //PeptideIon::bstar
    bool _c_ions = false; //PeptideIon::ystar
    bool _z_ions = false; //PeptideIon::z
    bool _a_ions = false; //PeptideIon::a
    bool _x_ions = false; //CO2
    bool _astar_ions = false; //PeptideIon::a
    bool _ao_ions = false; //PeptideIon::ao
    bool _bo_ions = false; //PeptideIon::bo
    bool _yo_ions = false; //PeptideIon::yo


};
}
#endif // XTANDEMSPECTRUMPROCESS_H
