
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#ifndef GRPMAPPEPTIDETOSUBGROUPSET_H
#define GRPMAPPEPTIDETOSUBGROUPSET_H

#include <list>

#include "grppeptide.h"
#include "grpsubgroupset.h"
#include "grppeptideset.h"

namespace pappso {
class GrpMapPeptideToSubGroupSet
{
public:
    GrpMapPeptideToSubGroupSet();
    GrpMapPeptideToSubGroupSet(const GrpMapPeptideToSubGroupSet & other):_map_peptide2subgroup_set(other._map_peptide2subgroup_set) {};
    ~GrpMapPeptideToSubGroupSet();
    void getSubGroupSet(const GrpPeptideSet & peptide_set_in, GrpSubGroupSet & ) const;
    void remove(GrpSubGroup* p_remove_sub_group);
    void add(GrpSubGroup* p_add_sub_group);
    bool hasSpecificPeptide(const GrpSubGroup* get) const;
    void check(std::list< GrpSubGroupSp > & _subgroup_list)const; 
    unsigned int size() const {return _map_peptide2subgroup_set.size();};
    const QString printInfos() const;

private :
    std::list<std::pair<GrpPeptide*, GrpSubGroupSet>> _map_peptide2subgroup_set;

};
}
#endif // GRPMAPPEPTIDETOSUBGROUPSET_H
