
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#include <QDebug>
#include <QTextStream>
#include "fastareader.h"
namespace pappso {
FastaReader::FastaReader(FastaHandlerInterface & handler): _handler(handler)
{

}

FastaReader::~FastaReader()
{

}


void FastaReader::parse(QFile & fastaFile) {
    fastaFile.open(QIODevice::ReadOnly);
    parse(&fastaFile);
    fastaFile.close();
}

void FastaReader::parse(QIODevice * p_inputstream) {

    qDebug() << "Begin parsing fasta";
    QTextStream p_in(p_inputstream);

    QString accession = "";
    QString sequence = "";
    //Search accession conta
    //QTextStream in(p_in);
    QString line = p_in.readLine();
    while (!p_in.atEnd()) {
        if (line.startsWith(">")) {
            if (!accession.isEmpty()) {
                _handler.setSequence(accession, sequence);
            }
            sequence = "";
            accession = line.remove(0, 1);
        } else {
            sequence.append(line);
            // _handler.setSequence(line);
        }
        line = p_in.readLine();
    }
    if (!accession.isEmpty()) {
        sequence.append(line);
        _handler.setSequence(accession, sequence);
    }
    //p_in->close();
}

}
