//
// File: test_hyperscore.cpp
// Created by: Olivier Langella
// Created on: 13/3/2015
//
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/


#include <iostream>
#include <pappsomspp/fasta/fastareader.h>
//#include "common.h"
#include "config.h"

using namespace pappso;
using namespace std;
//using namespace pwiz::msdata;

class FastaSeq: public FastaHandlerInterface {
public:
  void setSequence(const QString& description, const QString& sequence) override {
    cout << endl << description.toStdString() ;
    cout << endl << sequence.toStdString() << endl;
  };
};


int main() {

    cout << endl << "..:: Test Fasta reader ::.." << endl;
    
    QFile fastaFile(QString(CMAKE_SOURCE_DIR).append("/test/data/asr1_digested_peptides.txt"));
    FastaSeq seq;
    FastaReader reader(seq);
    reader.parse(fastaFile);
    
     /*
    Spectrum spectrum_low_masses(spectrum_parent.applyCutOff(150));
    if (! spectrum_low_masses.equals(sremove_low_masses, precision)) {
        cerr << "spectrum_low_masses() != tandem"<< endl;
        return 1;
    }*/
    
    return 0;
}
