
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#include <cmath>
#include "xicpeak.h"
#include "xic.h"

namespace pappso {
XicPeak::XicPeak()
{

}

XicPeak::XicPeak(const XicPeak& other)
{
    _area = other._area;
    _left = other._left;
    _right = other._right;
    _max = other._max;
}

XicPeak::~XicPeak()
{

}


XicPeakSp XicPeak::makeXicPeakSp() const {
    return std::make_shared<const XicPeak>(*this);
}

XicElement & XicPeak::getMaxXicElement() {
    return _max;
};
void XicPeak::setMaxXicElement(const XicElement & max) {
    _max = max;
};
XicElement & XicPeak::getLeftBoundary() {
    return _left;
};
void XicPeak::setLeftBoundary(const XicElement & left) {
    _left = left;
};

XicElement & XicPeak::getRightBoundary() {
    return _right;
};
const XicElement & XicPeak::getRightBoundary() const {
    return _right;
};
void XicPeak::setRightBoundary(const XicElement & right) {
    _right = right;
};
pappso_double XicPeak::getArea() const {
    return _area;
};
void XicPeak::setArea(pappso_double area) {
    _area = area;
};
void XicPeak::integrateXicElement(const XicElement & previous, const XicElement & current) {
    if (_left.rt == 0) {
        _left = previous;
    }
    if (_max.intensity < current.intensity) {
        _max = current;
    }
    _right = current;
    _area += ( (fabs((double) current.rt - previous.rt)) *
               (current.intensity + previous.intensity) ) / 2;
};


bool
XicPeak::containsRt(pappso::pappso_double rt) const {
    if ( (rt >= _left.rt) &&
            (rt <= _right.rt) ) {
        return (true);
    }
    return (false);
}

}
