
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/


#ifndef XICFILTERBACKGROUND_H
#define XICFILTERBACKGROUND_H

#include "./xicfilterinterface.h"
#include "xicfiltermax.h"

namespace pappso {

class XicFilterNegative: public XicFilterInterface
{

protected :
    void filterInternal (const Xic & xic, Xic & newxic) const override;

};

class XicFilterBackground: public XicFilterInterface
{
public:
    XicFilterBackground();
    void setMedianHalfEdgeWindows(unsigned int half_edge_windows) {
        _median_half_edge_windows=half_edge_windows;
    };
    void setMinMaxHalfEdgeWindows(unsigned int half_edge_windows) {
        _min_max.setHalfEdgeWindows(half_edge_windows);
    };
    unsigned int getMedianHalfEdgeWindows() const {
        return _median_half_edge_windows;
    };
    unsigned int getMinMaxHalfEdgeWindows() const {
        return _min_max.getHalfEdgeWindows();
    };

protected :
    void filterInternal (const Xic & xic, Xic & newxic) const override;

private :
    unsigned int _median_half_edge_windows=0;

    XicFilterMinMax _min_max;
    XicFilterNegative _negative;
};
}
#endif // XICFILTERBACKGROUND_H
