
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/
#include "xicfilterbackground.h"


namespace pappso {

pappso_double
get_median(std::vector<XicElement>::const_iterator beginit, std::vector<XicElement>::const_iterator endit) {
    unsigned long nb_element = distance(beginit, endit);
    std::vector<XicElement> vcopy;
    vcopy.resize(nb_element);
    std::copy(beginit, endit, vcopy.begin());
    std::sort(vcopy.begin(), vcopy.end());

    pappso_double result(0);
    if (nb_element % 2 == 0) {
        std::vector<XicElement>::const_iterator centerit1(vcopy.begin() + (nb_element / 2) - 1);
        std::vector<XicElement>::const_iterator centerit2(centerit1 + 1);
        result = (centerit1->intensity + centerit2->intensity) / 2;
    } else {
        std::vector<XicElement>::const_iterator centerit(vcopy.begin() + (nb_element / 2));
        result = centerit->intensity;
    }
    return result;
}


void XicFilterNegative::filterInternal (const Xic & xic, Xic & newxic) const {

    newxic = xic;
    auto it = newxic.begin();
    while (it != newxic.end()) {
        if (it->intensity <0) {
            it->intensity = 0;
        }
        it++;
    }
}

XicFilterBackground::XicFilterBackground()
{
    _min_max.setSink(&_negative);
    this->setSink(&_min_max);
}

void XicFilterBackground::filterInternal (const Xic & xic, Xic & newxic) const {
    xic.newXicByApplyingWindowsOperation(_median_half_edge_windows,&get_median,newxic);
}

}
