
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/


#ifndef XICDETECTIONZIVY_H
#define XICDETECTIONZIVY_H

#include "xicdetectioninterface.h"
#include "../filters/xicfiltersmoothing.h"
#include "../filters/xicfiltermax.h"


namespace pappso {
class XicDetectionZivy: public XicDetectionInterface
{
public:
    XicDetectionZivy();

    void setSmoothingHalfEdgeWindows(unsigned int smoothing_half_window_length) {
        _smooth.setSmoothingHalfEdgeWindows(smoothing_half_window_length);
    };
    void setMaxMinHalfEdgeWindows(unsigned int maxmin_half_window_length) {
        _maxmin.setHalfEdgeWindows(maxmin_half_window_length);
    };

    void setMinMaxHalfEdgeWindows(unsigned int minmax_half_window_length) {
        _minmax.setHalfEdgeWindows(minmax_half_window_length);
    };
    void setDetectionThresholdOnMinmax(pappso_double detection_threshold_on_minmax) {
        _detection_threshold_on_minmax= detection_threshold_on_minmax;
    };
    void setDetectionThresholdOnMaxmin(pappso_double detection_threshold_on_maxmin) {
        _detection_threshold_on_maxmin= detection_threshold_on_maxmin;
    };


    unsigned int getSmoothingHalfEdgeWindows() const {
        return _smooth.getSmoothingHalfEdgeWindows();
    };
    unsigned int getMaxMinHalfEdgeWindows() const {
        return _maxmin.getHalfEdgeWindows();
    };

    unsigned int getMinMaxHalfEdgeWindows() const {
        return _minmax.getHalfEdgeWindows();
    };
    pappso_double getDetectionThresholdOnMinmax() const {
        return  _detection_threshold_on_minmax;
    };
    pappso_double getDetectionThresholdOnMaxmin() const {
        return _detection_threshold_on_maxmin;
    };

    void detect (const Xic & xic,XicDetectionSinkInterface * sink) const override;

private:

    XicFilterSmoothing _smooth;
    XicFilterMaxMin _maxmin;
    XicFilterMinMax _minmax;
    pappso_double _detection_threshold_on_minmax;
    pappso_double _detection_threshold_on_maxmin;

};
}

#endif // XICDETECTIONZIVY_H
