
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/
#ifndef XICDETECTIONMOULON_H
#define XICDETECTIONMOULON_H

#include "xicdetectioninterface.h"
#include "../filters/xicfiltersmoothing.h"

namespace pappso {
class XicDetectionMoulon: public XicDetectionInterface
{
public:
    XicDetectionMoulon();

    void setSmoothingHalfEdgeWindows(unsigned int smoothing_half_window_length) {
        _smooth.setSmoothingHalfEdgeWindows(smoothing_half_window_length);
    };

    void setTicStart(pappso_double tic_start) {
        _tic_start= tic_start;
    };

    void setTicStop(pappso_double tic_stop) {
        _tic_stop= tic_stop;
    };

    unsigned int getSmoothingHalfEdgeWindows() const {
        return _smooth.getSmoothingHalfEdgeWindows();
    };

    pappso_double getTicStart() const {
        return  _tic_start;
    };

    pappso_double getTicStop(pappso_double tic_stop) const {
        return  _tic_stop;
    };


    void detect (const Xic & xic,XicDetectionSinkInterface * sink) const override;

private:

    XicFilterSmoothing _smooth;
    pappso_double _tic_start;
    pappso_double _tic_stop;

};
}
#endif // XICDETECTIONMOULON_H
