
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/
#ifndef QUALIFIEDSPECTRUM_H
#define QUALIFIEDSPECTRUM_H

#include "spectrum.h"
#include "spectrumid.h"

namespace pappso {
class QualifiedSpectrum
{
public:
    QualifiedSpectrum(const SpectrumId & spectrum_id);
    QualifiedSpectrum();
    ~QualifiedSpectrum();

    const SpectrumId & getSpectrumId() const {
        return _spectrum_id;
    };
    void setSpectrumId(const SpectrumId & original_spectrum_id) {
        _spectrum_id = original_spectrum_id;
    };
    
    void setOriginalSpectrumSp(SpectrumSp & original_spectrum_sp) {
        _original_spectrum_sp = original_spectrum_sp;
    };
    SpectrumSp getOriginalSpectrumSp() const {
        return _original_spectrum_sp;
    };
    void setPrecursorCharge(unsigned int precursor_charge) {
        _precursor_charge=precursor_charge;
    };
    unsigned int getPrecursorCharge() const {
        return _precursor_charge;
    };
    void setPrecursorMz(mz precursor_mz) {
        _precursor_mz=precursor_mz;
    };
    mz getPrecursorMz() const {
        return _precursor_mz;
    };
    void setMsLevel(unsigned int ms_level) {
        _ms_level=ms_level;
    };
    unsigned int getMsLevel() const {
        return _ms_level;
    };
    void setRtInSeconds(pappso_double rt_in_seconds) {
        _rt_in_seconds = rt_in_seconds;
    };
    pappso_double getRtInSeconds() const {
        return _rt_in_seconds;
    };

private :
    SpectrumId _spectrum_id;

    SpectrumSp _original_spectrum_sp;

    unsigned int _precursor_charge=0;
    mz _precursor_mz=0;
    pappso_double _precursor_intensity=0;
    unsigned int _ms_level=0;

    pappso_double _rt_in_seconds=0;


};
}
#endif // QUALIFIEDSPECTRUM_H
