/*
 * /*******************************************************************************
 * * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 * *
 * * This file is part of MassChroqPRM.
 * *
 * *     MassChroqPRM is free software: you can redistribute it and/or modify
 * *     it under the terms of the GNU General Public License as published by
 * *     the Free Software Foundation, either version 3 of the License, or
 * *     (at your option) any later version.
 * *
 * *     MassChroqPRM is distributed in the hope that it will be useful,
 * *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 * *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * *     GNU General Public License for more details.
 * *
 * *     You should have received a copy of the GNU General Public License
 * *     along with MassChroqPRM.  If not, see <http://www.gnu.org/licenses/>.
 * *
 * * Contributors:
 * *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 * ******************************************************************************/

#ifndef PEPTIDEISOTOPESPECTRUMMATCH_H
#define PEPTIDEISOTOPESPECTRUMMATCH_H


#include "../spectrum/spectrum.h"
#include "../mass_range.h"
#include "../peptide/peptidefragmention.h"
#include "../peptide/peptidefragmentionlistbase.h"
#include "peakionisotopematch.h"

namespace pappso {
class PeptideIsotopeSpectrumMatch
{
public:
    PeptideIsotopeSpectrumMatch(const Spectrum & spectrum, const PeptideSp & peptideSp, unsigned int parent_charge, PrecisionP precision, std::list<PeptideIon> ion_list, unsigned int maxIsotopeLevel, unsigned int maxIsotopeRank);
    PeptideIsotopeSpectrumMatch(const Spectrum & spectrum, std::vector<PeptideNaturalIsotopeAverageSp> v_peptideIsotopeList, std::vector<PeptideFragmentIonSp> v_peptideIonList, PrecisionP precision);
    PeptideIsotopeSpectrumMatch(const PeptideIsotopeSpectrumMatch& other);

    ~PeptideIsotopeSpectrumMatch();


    typedef std::list<PeakIonIsotopeMatch>::const_iterator const_iterator;

    unsigned int size() const {
        return _peak_ion_match_list.size();
    }
    const_iterator begin() const {
        return _peak_ion_match_list.begin();
    }
    const_iterator end() const {
        return _peak_ion_match_list.end();
    }

private:
    virtual std::list<Peak>::iterator getBestPeakIterator (std::list<Peak> & peak_list, const PeptideNaturalIsotopeAverage & ion) const;

    PrecisionP _precision;
    std::list<PeakIonIsotopeMatch> _peak_ion_match_list;
};
}
#endif // PEPTIDEISOTOPESPECTRUMMATCH_H
