/*
 * /*******************************************************************************
 * * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 * *
 * * This file is part of MassChroqPRM.
 * *
 * *     MassChroqPRM is free software: you can redistribute it and/or modify
 * *     it under the terms of the GNU General Public License as published by
 * *     the Free Software Foundation, either version 3 of the License, or
 * *     (at your option) any later version.
 * *
 * *     MassChroqPRM is distributed in the hope that it will be useful,
 * *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 * *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * *     GNU General Public License for more details.
 * *
 * *     You should have received a copy of the GNU General Public License
 * *     along with MassChroqPRM.  If not, see <http://www.gnu.org/licenses/>.
 * *
 * * Contributors:
 * *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 * ******************************************************************************/

#ifndef PEAKIONISOTOPEMATCH_H
#define PEAKIONISOTOPEMATCH_H

#include "peakionmatch.h"
#include "../peptide/peptidenaturalisotopeaverage.h"

namespace pappso {
class PeakIonIsotopeMatch : public PeakIonMatch
{
public:
    PeakIonIsotopeMatch(const Peak & peak,const PeptideNaturalIsotopeAverageSp & naturalIsotopeAverageSp, const PeptideFragmentIonSp & ion_sp);
    PeakIonIsotopeMatch(const PeakIonIsotopeMatch& other);
    ~PeakIonIsotopeMatch();

    virtual const PeptideNaturalIsotopeAverageSp & getPeptideNaturalIsotopeAverageSp() const {
        return _naturalIsotopeAverageSp;
    };

private:
    const PeptideNaturalIsotopeAverageSp _naturalIsotopeAverageSp;
};
}

#endif // PEAKIONISOTOPEMATCH_H
