
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#ifndef PEPTIDEVARIABLEMODIFICATIONBUILDER_H
#define PEPTIDEVARIABLEMODIFICATIONBUILDER_H

#include "peptidemodificatorbase.h"

namespace pappso {


/** \brief Modify a peptide shared pointer with a variable modification on one AA
* */
class PeptideVariableModificationBuilder: public PeptideModificatorBase
{
public:
    PeptideVariableModificationBuilder(AaModificationP mod);
    ~PeptideVariableModificationBuilder();
    void setPeptideSp(std::int8_t sequence_database_id, const ProteinSp & protein_sp, bool is_decoy, const PeptideSp & peptide_sp_original, unsigned int start, bool is_nter, unsigned int missed_cleavage_number, bool semi_enzyme) override;

    void addAa(char aa);

    void setMaxNumberMod(unsigned int max_num) {
        _max_number_mod = max_num;
    };
    void setMinNumberMod(unsigned int min_num) {
        _min_number_mod = min_num;
    };
    void setModificationCounter(unsigned int counter) {
        _modification_counter = counter;
    };

    void setSink (PeptideModificatorInterface * sink) override {
        _sink = sink;
    };



    /** \brief this modification concerns the Nter peptide
     * */
    void setProtNter(bool arg1) {
        _prot_nter_mod=arg1;
    };
    /** \brief this modification concerns the Cter peptide
     * */
    void setProtCter(bool arg1) {
        _prot_cter_mod=arg1;
    };
    /** \brief this modification concerns all peptides between Nter and Cter
     * */
    void setProtElse(bool arg1) {
        _prot_else_mod=arg1;
    };

protected :
  
    static bool next_combination(const std::vector<unsigned int>::iterator first, std::vector<unsigned int>::iterator k, const std::vector<unsigned int>::iterator last);

    PeptideModificatorInterface * _sink=nullptr;
    AaModificationP _mod;
    //minimum number of positions to modify
    unsigned int _min_number_mod=0;
    //maximum number of positions to modify
    unsigned int _max_number_mod=30000;
    //modification counter per site
    unsigned int _modification_counter = 0;

    //protein Nter modification
    bool _prot_nter_mod = true;
    //protein Cter modification
    bool _prot_cter_mod = true;

    bool _prot_else_mod = true;


private :

    QString _aa_modification_list;


};
}

#endif // PEPTIDEVARIABLEMODIFICATIONBUILDER_H
