
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/
#ifndef MSRUNID_H
#define MSRUNID_H

#include <QString>
#include <QMutex>
#include <memory>

namespace pappso {

  
class MsRunId;
typedef std::shared_ptr<const MsRunId> MsRunIdSp;

class MsRunId
{
public:
    MsRunId();
    MsRunId(const QString & filename);
    MsRunId(const MsRunId& other);
    MsRunIdSp makeMsRunIdSp() const;
    ~MsRunId();
    bool operator==(const MsRunId& other) const;
    MsRunId& operator=(const MsRunId& other);


    void setFilename(const QString & filename) {
        _filename = filename;
    };
    const QString & getFilename() const {
        return _filename;
    };
    void setXmlId(const QString & xml_id) {
        _xml_id = xml_id;
    };
    const QString & getXmlId() const {
        return _xml_id;
    };

private :
    static QMutex _smutex;
    static unsigned int _count;
    
    QString _filename;
    QString _xml_id;

};
}

#endif // MSRUNID_H
