
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#ifndef GRPSUBGROUPSET_H
#define GRPSUBGROUPSET_H

#include "grpsubgroup.h"

namespace pappso {
class GrpGroup;

class GrpSubGroupSet
{
    friend GrpGroup;
public:
    GrpSubGroupSet();
    GrpSubGroupSet(const GrpSubGroupSet & other);
    ~GrpSubGroupSet();
    unsigned int size() const {
        return _list_p_subgroup.size();
    };
    void addAll(const GrpSubGroupSet & other);
    void remove(GrpSubGroup* p_remove_sub_group);
    void add(GrpSubGroup* p_add_sub_group);
    std::_List_iterator< GrpSubGroup* > erase(std::_List_iterator< GrpSubGroup* > it) {
        return _list_p_subgroup.erase(it);
    };
    std::list<GrpSubGroup *>::const_iterator begin() const {
        return _list_p_subgroup.begin();
    };
    std::list<GrpSubGroup *>::const_iterator end() const {
        return _list_p_subgroup.end();
    };
    bool contains(GrpSubGroup* get) const;
    
    const QString printInfos() const;
    

private :
    std::list<GrpSubGroup *> _list_p_subgroup;
};
}
#endif // GRPSUBGROUPSET_H
