
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#ifndef GRPPEPTIDE_H
#define GRPPEPTIDE_H

#include <QString>
#include "../types.h"

namespace pappso {

class GrpPeptide
{
    friend class GrpExperiment;
public:
    ~GrpPeptide();
    const QString & getSequence() const;
    
    /** \brief sort grp peptides between each other
     * sorts by peptide LI sequence and mass
     */
    bool operator<(const GrpPeptide& other) const;

    void setRank(unsigned int i);
    void setGroupNumber(unsigned int i);

    const QString getGroupingId() const;
    unsigned int getGroupNumber() const ;
    unsigned int getRank() const ;

protected:
    GrpPeptide(QString sequence, pappso_double mass);

private:
    unsigned int _group_number=0;
    unsigned int _rank=0;

    const QString _sequence;
    const pappso_double _mass;

};
}
#endif // GRPPEPTIDE_H
