
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#ifndef GRPGROUPINGMONITOR_H
#define GRPGROUPINGMONITOR_H

namespace pappso {
  
class GrpGroupingMonitorInterface
{
public:
    virtual void startGrouping(std::size_t total_number_protein) =0;
    virtual void groupingProtein()=0;
    virtual void startRemovingNonInformativeSubGroupsInAllGroups(std::size_t total_number_group)=0;
    virtual void stopRemovingNonInformativeSubGroupsInAllGroups(std::size_t total_number_group)=0;
    virtual void removingNonInformativeSubGroupsInGroup()=0;
    virtual void startNumberingAllGroups(std::size_t total_number_group)=0;
    virtual void stopGrouping()=0;
};

class GrpGroupingMonitor: public GrpGroupingMonitorInterface
{
public:
    GrpGroupingMonitor();
    ~GrpGroupingMonitor();
    virtual void startGrouping(std::size_t total_number_protein);
    virtual void groupingProtein();
    virtual void startRemovingNonInformativeSubGroupsInAllGroups(std::size_t total_number_group);
    virtual void stopRemovingNonInformativeSubGroupsInAllGroups(std::size_t total_number_group);
    virtual void removingNonInformativeSubGroupsInGroup();
    virtual void startNumberingAllGroups(std::size_t total_number_group);
    virtual void stopGrouping();
private:
    QTextStream* _p_out;
    std::size_t _total_number_protein;
    std::size_t _current_protein;
};
}
#endif // GRPGROUPINGMONITOR_H
